<?php
class CertificadoController {
    public static function carregar($arquivoCertificado, $senhaCertificado) {
        if (!file_exists($arquivoCertificado)) {
            die(json_encode(["status" => "error", "message" => "Certificado no encontrado: " . $arquivoCertificado]));
        }

        $certs = [];
        $conteudo = file_get_contents($arquivoCertificado);
        if (!openssl_pkcs12_read($conteudo, $certs, $senhaCertificado)) {
            die(json_encode(["status" => "error", "message" => "Erro ao carregar o certificado digital. Senha incorreta?"]));
        }

        return (object) [
            "privateKey" => $certs["pkey"],
            "certificate" => $certs["cert"]
        ];
    }

    public static function formatarCertificado($cert) {
        return trim(str_replace(["-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----", "\n", "\r"], "", $cert));
    }

    public static function extrairCertificadoDoXml($xml) {
        $doc = new DOMDocument();
        $doc->loadXML($xml);
        $xpath = new DOMXPath($doc);
        $xpath->registerNamespace('ds', 'http://www.w3.org/2000/09/xmldsig#');

        $certNode = $xpath->query('//ds:X509Certificate')->item(0);
        if (!$certNode) {
            die(json_encode(["status" => "error", "message" => "Erro: Certificado X509 no encontrado no XML assinado."]));
        }

        return trim($certNode->nodeValue);
    }
}