<?php
// Função para exibir erros com layout
function exibirErro($mensagem, $tipo = 'error') {
    $tipos = [
        'error' => ['classe' => 'alert-danger', 'icone' => 'simple-icon-exclamation', 'titulo' => 'Erro'],
        'warning' => ['classe' => 'alert-warning', 'icone' => 'simple-icon-exclamation', 'titulo' => 'Atenção'],
        'success' => ['classe' => 'alert-success', 'icone' => 'simple-icon-check', 'titulo' => 'Sucesso'],
        'info' => ['classe' => 'alert-info', 'icone' => 'simple-icon-info', 'titulo' => 'Informação']
    ];
    
    $config = $tipos[$tipo] ?? $tipos['error'];
    
    echo '<div class="alert ' . $config['classe'] . ' alert-dismissible fade show" role="alert">
            <i class="' . $config['icone'] . ' mr-2"></i>
            <strong>' . $config['titulo'] . ':</strong> ' . htmlspecialchars($mensagem) . '
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
          </div>';
}

// Inicialização de variáveis globais
$personalizar_contabil = false;
$personalizar_fiscal = false;
$personalizar_dp = false;
$inflacao = 0.1;
$total_contabilidade = 0;
$total_fiscal_final = 0;
$total_dp = 0;
$exibir_contabilidade = false;
$exibir_fiscal = false;
$exibir_dp = false;

// Arrays para armazenar os valores de cada regime de tributação e atividade
$tributos = [
    "Simples Nacional" => [
        "Serviço" => 30,
        "Comércio" => 40,
        "Indústrias" => 100,
        "ONGs" => 100,
        "Comércio e Serviço" => 100,
        "Construtora" => 100,
        "faturamento" => [
            "Contabilidade Pelo Caixa" => 10,  
            "0 a 10 MIL" => 20,
            "10 a 20 MIL" => 30,
            "20 a 30 MIL" => 40,
            "30 a 40 MIL" => 50,
            "40 a 50 MIL" => 60,
            "50 a 100 MIL" => 70,
            "100 a 200 MIL" => 80,
            "200 a 300 MIL" => 90,
            "300 a 400 MIL" => 100,
            "400 a 500 MIL" => 120,
            "500 a 600 MIL" => 140,
            "600 a 700 MIL" => 160,
            "700 a 800 MIL" => 180,
            "800 a 900 MIL" => 190,
            "900 a 1.000.000 MIL" => 200,
            "ACIMA DE 1.000.000 MIL" => "Personalizar"
        ]
    ],
    "Lucro Real" => [
        "Serviço" => 100,
        "Comércio" => 150,
        "Indústrias" => 180,
        "ONGs" => 180,
        "Comércio e Serviço" => 180,
        "Construtora" => 200,
        "faturamento" => [
            "Contabilidade Pelo Caixa" => 60,
            "0 a 10 MIL" => 30,
            "10 a 20 MIL" => 45,
            "20 a 30 MIL" => 60,
            "30 a 40 MIL" => 80,
            "40 a 50 MIL" => 100,
            "50 a 100 MIL" => 130,
            "100 a 200 MIL" => 150,
            "200 a 300 MIL" => 170,
            "300 a 400 MIL" => 190,
            "400 a 500 MIL" => 200,
            "500 a 600 MIL" => 220,
            "600 a 700 MIL" => 240,
            "700 a 800 MIL" => 260,
            "800 a 900 MIL" => 280,
            "900 a 1.000.000 MIL" => 300,
            "ACIMA DE 1.000.000 MIL" => "Personalizar"
        ]
    ],
    "Lucro Presumido" => [
        "Serviço" => 50,
        "Comércio" => 60,
        "Indústrias" => 110,
        "ONGs" => 110,
        "Comércio e Serviço" => 110,
        "Construtora" => 110,
        "faturamento" => [
            "Contabilidade Pelo Caixa" => 60,
            "0 a 10 MIL" => 35,
            "10 a 20 MIL" => 50,
            "20 a 30 MIL" => 70,
            "30 a 40 MIL" => 90,
            "40 a 50 MIL" => 110,
            "50 a 100 MIL" => 180,
            "100 a 200 MIL" => 200,
            "200 a 300 MIL" => 220,
            "300 a 400 MIL" => 240,
            "400 a 500 MIL" => 250,
            "500 a 600 MIL" => 270,
            "600 a 700 MIL" => 290,
            "700 a 800 MIL" => 310,
            "800 a 900 MIL" => 330,
            "900 a 1.000.000 MIL" => 350,
            "ACIMA DE 1.000.000 MIL" => "Personalizar"
        ]
    ]
];

// Arrays para armazenar os valores fiscais/tributários
$tributos_fiscal = [
    "Simples Nacional" => [
        "Serviço" => 50,
        "Comércio" => 80,
        "Indústrias" => 100,
        "ONGs" => 100,
        "Comércio e Serviço" => 100,
        "Construtora" => 100,
        "faturamento" => [
            "0 a 10 MIL" => 10,
            "10 a 20 MIL" => 13,
            "20 a 30 MIL" => 15,
            "30 a 40 MIL" => 18,
            "40 a 50 MIL" => 22,
            "50 a 100 MIL" => 28,
            "100 a 200 MIL" => 50,
            "200 a 300 MIL" => 55,
            "300 a 400 MIL" => 70,
            "400 a 500 MIL" => 75,
            "500 a 600 MIL" => 100,
            "600 a 700 MIL" => 130,
            "700 a 800 MIL" => 160,
            "800 a 900 MIL" => 190,
            "900 a 1.000.000 MIL" => 250,
            "ACIMA DE 1.000.000 MIL" => "Personalizar"
        ]
    ],
    "Lucro Real" => [
        "Serviço" => 150,
        "Comércio" => 200,
        "Indústrias" => 200,
        "ONGs" => 200,
        "Comércio e Serviço" => 200,
        "Construtora" => 200,
        "faturamento" => [
            "0 a 10 MIL" => 30,
            "10 a 20 MIL" => 45,
            "20 a 30 MIL" => 60,
            "30 a 40 MIL" => 80,
            "40 a 50 MIL" => 100,
            "50 a 100 MIL" => 130,
            "100 a 200 MIL" => 150,
            "200 a 300 MIL" => 170,
            "300 a 400 MIL" => 190,
            "400 a 500 MIL" => 200,
            "500 a 600 MIL" => 220,
            "600 a 700 MIL" => 240,
            "700 a 800 MIL" => 260,
            "800 a 900 MIL" => 280,
            "900 a 1.000.000 MIL" => 300,
            "ACIMA DE 1.000.000 MIL" => "Personalizar"
        ]
    ],
    "Lucro Presumido" => [
        "Serviço" => 100,
        "Comércio" => 150,
        "Indústrias" => 150,
        "ONGs" => 150,
        "Comércio e Serviço" => 150,
        "Construtora" => 150,
        "faturamento" => [
            "0 a 10 MIL" => 35,
            "10 a 20 MIL" => 50,
            "20 a 30 MIL" => 70,
            "30 a 40 MIL" => 90,
            "40 a 50 MIL" => 110,
            "50 a 100 MIL" => 180,
            "100 a 200 MIL" => 200,
            "200 a 300 MIL" => 220,
            "300 a 400 MIL" => 240,
            "400 a 500 MIL" => 250,
            "500 a 600 MIL" => 270,
            "600 a 700 MIL" => 290,
            "700 a 800 MIL" => 310,
            "800 a 900 MIL" => 330,
            "900 a 1.000.000 MIL" => 350,
            "ACIMA DE 1.000.000 MIL" => "Personalizar"
        ]
    ]
];

// Função para mapear valores dos selects para os arrays
function mapearValores($valor_select, $tipo) {
    $mapeamento = [
        'tributo' => [
            'mei' => 'MEI',
            'rural' => 'Produtor Rural',
            'lucro_real' => 'Livro Caixa',
            'Simples' => 'Simples Nacional',
            'Real' => 'Lucro Real',
            'Presumido' => 'Lucro Presumido',
            'Imune' => 'Lucro Presumido'
        ],
        'atividade' => [
            'servico' => 'Serviço',
            'comercio' => 'Comércio',
            'industria' => 'Indústrias',
            'Terceiro_setor' => 'ONGs',
            'comercio_e_serv' => 'Comércio e Serviço',
            'construtora' => 'Construtora'
        ],
        'modalidade' => [
            'Sem Movimento' => 'Sem Movimento',
            'Eventos Fixos' => 'Eventos Fixos',
            'Eventos Variáveis' => 'Eventos Variáveis',
            'Horista' => 'Horista'
        ],
        'sim_nao' => [
            '1' => 'SIM',
            '2' => 'NÃO',
            'sim' => 'SIM',
            'não' => 'NÃO',
            'SIM' => 'SIM',
            'NÃO' => 'NÃO'
        ],
        'qtd_funcionarios' => [
            // Mapeamento direto - o valor já é o número correto
            '1' => 1,
            '2' => 2,
            '3' => 3,
            '4' => 4,
            '5' => 5,
            '10' => 10,
            '20' => 20,
            '30' => 30,
            '40' => 40,
            '50' => 50
        ]
    ];
    
    return $mapeamento[$tipo][$valor_select] ?? $valor_select;
}

// Função para calcular desconto por período
function calcularDescontoPeriodo($total, $periodo) {
    switch ($periodo) {
        case "Semestral":
            $total_periodo = $total * 6;
            $desconto = $total_periodo * 0.4; // 40% de desconto
            $total_com_desconto = $total_periodo - $desconto;
            echo "<div class='card mb-4'><div class='card-body'><h5 style='color: red;'>Total da Contabilidade Semestral com desconto:</h5><h1>R$: " . number_format($total_com_desconto, 2, ',', '.') . "</h1></div></div>";
            return $total; // Retorna o valor mensal
            
        case "Trimestral":
            $total_periodo = $total * 3;
            $desconto = $total_periodo * 0.3; // 30% de desconto
            $total_com_desconto = $total_periodo - $desconto;
            echo "<div class='card mb-4'><div class='card-body'><h5 style='color: red;'>Total da Contabilidade Trimestral com desconto:</h5><h1>R$: " . number_format($total_com_desconto, 2, ',', '.') . "</h1></div></div>";
            return $total; // Retorna o valor mensal
            
        case "Anual":
            $total_periodo = $total * 12;
            $desconto = $total_periodo * 0.5; // 50% de desconto
            $total_com_desconto = $total_periodo - $desconto;
            echo "<div class='card mb-4'><div class='card-body'><h5 style='color: red;'>Total da Contabilidade Anual com desconto:</h5><h1>R$: " . number_format($total_com_desconto, 2, ',', '.') . "</h1></div></div>";
            return $total; // Retorna o valor mensal
            
        default: // Mensal
            return $total;
    }
}

// Função para calcular total com inflação
function calcularComInflacao($valor, $inflacao = 0.1) {
    return $valor + ($valor * 0.3642) + (($valor + ($valor * 0.3642)) * $inflacao);
}

// Debug: Verificar dados recebidos (comentar para produção)
/*
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<div style='background: #f0f0f0; padding: 10px; margin: 10px 0; border: 1px solid #ccc;'>";
    echo "<h4>Debug - Dados Recebidos:</h4>";
    echo "<pre>" . print_r($_POST, true) . "</pre>";
    echo "</div>";
}
*/

// Verificar quais departamentos foram preenchidos
$contabil_preenchido = !empty($_POST["tributoEscolhido_contabil"]);
$fiscal_preenchido = !empty($_POST["tributoEscolhido_tribut"]);
$dp_preenchido = !empty($_POST["modalidade_folhaEscolhido"]);

$departamentos_preenchidos = 0;
if ($contabil_preenchido) $departamentos_preenchidos++;
if ($fiscal_preenchido) $departamentos_preenchidos++;
if ($dp_preenchido) $departamentos_preenchidos++;

// Debug temporário - remover depois
// echo "<div class='alert alert-info'>";
// echo "<strong>Debug:</strong> Departamentos preenchidos: $departamentos_preenchidos<br>";
// echo "Contábil: " . ($contabil_preenchido ? 'SIM' : 'NÃO') . "<br>";
// echo "Fiscal: " . ($fiscal_preenchido ? 'SIM' : 'NÃO') . "<br>";
// echo "DP: " . ($dp_preenchido ? 'SIM' : 'NÃO') . "<br>";
// echo "</div>";

// Verificar se pelo menos um departamento foi preenchido
if ($departamentos_preenchidos == 0) {
    echo "<div class='alert alert-warning'><h4>Atenção</h4><p>Por favor, preencha pelo menos um departamento para gerar o orçamento.</p></div>";
    exit;
}

// Define casos especiais (usado por contábil e fiscal)
$casos_especiais = ["MEI", "Produtor Rural", "Livro Caixa"];

// ===== PROCESSAMENTO CONTÁBIL =====
if ($contabil_preenchido) {
    $tributo = mapearValores($_POST["tributoEscolhido_contabil"], 'tributo');
    $atividade = mapearValores($_POST["atividadeEscolhida_contabil"], 'atividade');
    $faturamento = $_POST["faturamentoEscolhido_contabil"];
    
    // Validação da modalidade da contabilidade
    $prazodeentrega = $_POST['prazodeentrega_contabilescolhido'] ?? "";
    if (empty($prazodeentrega)) {
        exibirErro("Por favor, selecione a modalidade de entrega da contabilidade (Mensal, Trimestral, Semestral ou Anual).", 'warning');
        exit;
    }
    
    // Validação das opções válidas
    $modalidades_validas = ["Mensal", "Trimestral", "Semestral", "Anual"];
    if (!in_array($prazodeentrega, $modalidades_validas)) {
        exibirErro("Modalidade de entrega inválida. Opções válidas: Mensal, Trimestral, Semestral ou Anual.", 'error');
        exit;
    }
    
    if (in_array($tributo, $casos_especiais)) {
        $total_contabilidade = 70;
        if (mapearValores($_POST["dashboardBIEscolhido_contabil"], 'sim_nao') == "SIM") {
            $total_contabilidade += 50;
        }
        
        // Casos especiais não recebem desconto por período
        $exibir_contabilidade = true;
        
    } else {
        // Processamento normal para outros regimes
        if (isset($tributos[$tributo])) {
            $tributoData = $tributos[$tributo];
            $total = 0;
            
            // Verifica se "Contabilidade Pelo Caixa" foi selecionado
            if ($faturamento === "Contabilidade Pelo Caixa") {
                $total = 40;
                if ($tributo === "Lucro Real") {
                    echo "<div class='card mb-4'><div class='card-body'><h2 style='color: red;'>Contabilidade para lucro real não pode ser pelo caixa</h2></div></div>";
                }
            } else {
                // Adiciona valor da atividade
                if (isset($tributoData[$atividade])) {
                    $total += $tributoData[$atividade];
                } else {
                    exibirErro("Atividade não encontrada. Valor: '$atividade'. Verifique o valor enviado.");
                }
                
                // Adiciona valor do faturamento
                if (isset($tributoData["faturamento"][$faturamento])) {
                    if ($tributoData["faturamento"][$faturamento] !== "Personalizar") {
                        $total += $tributoData["faturamento"][$faturamento];
                    } else {
                        $personalizar_contabil = true;
                    }
                } else {
                    exibirErro("Faturamento não encontrado. Valor: '$faturamento'. Verifique o valor enviado.");
                }
            }
            
            // Aplica opções adicionais
            $subtotal = $total;
            if (mapearValores($_POST["licitacaoEscolhido_contabil"], 'sim_nao') == "SIM") {
                $total += $subtotal * 0.2;
            }
            if (mapearValores($_POST["entidade_govEscolhido_contabil"], 'sim_nao') == "SIM") {
                $total += $subtotal * 0.2;
            }
            if (mapearValores($_POST["atendimento_cliEscolhido_contabil"], 'sim_nao') == "SIM") {
                $total += $subtotal * 0.5;
            }
            if (mapearValores($_POST["dashboardBIEscolhido_contabil"], 'sim_nao') == "SIM") {
                $total += 50;
            }
            if (mapearValores($_POST["prazoEntregaEscolhido_contabil"], 'sim_nao') == "SIM") {
                $total += $subtotal * 0.2;
            }
            
            // Calcula com inflação
            $total_contabilidade = calcularComInflacao($total, $inflacao);
            
            // Verifica atendimento pelo Backoffice
            if (mapearValores($_POST["atendimento_cliEscolhido_contabil"], 'sim_nao') == "SIM") {
                $acrescimo_backoffice = $total_contabilidade * 0.10;
                $total_contabilidade += $acrescimo_backoffice;
            }
            
            // Aplica desconto por período (usando a variável já validada)
            // A variável $total_contabilidade mantém o valor mensal
            calcularDescontoPeriodo($total_contabilidade, $prazodeentrega);
            
            // Define que deve exibir a contabilidade
            $exibir_contabilidade = true;
            
        } else {
            exibirErro("Regime de tributação não encontrado. Valor: '$tributo'. Verifique o valor enviado.");
        }
    }
}

// ===== PROCESSAMENTO TRIBUTÁRIO =====
if ($fiscal_preenchido) {
    $tributo_fiscal = mapearValores($_POST["tributoEscolhido_tribut"], 'tributo');
    $atividade_fiscal = mapearValores($_POST["atividadeEscolhida_trib"], 'atividade');
    $faturamento_fiscal = $_POST["faturamentoEscolhido_trib"];
    
    // Verifica se é um caso especial
    if (in_array($tributo_fiscal, $casos_especiais)) {
        $total_fiscal_final = 70;
        $exibir_fiscal = true;
        
    } else {
        // Processamento normal para outros regimes
        if (isset($tributos_fiscal[$tributo_fiscal])) {
            $tributoDataFiscal = $tributos_fiscal[$tributo_fiscal];
            $total_fiscal = 0;
            
            // Adiciona valor da atividade
            if (isset($tributoDataFiscal[$atividade_fiscal])) {
                $total_fiscal += $tributoDataFiscal[$atividade_fiscal];
            } else {
                exibirErro("Atividade fiscal não encontrada. Valor: '$atividade_fiscal'. Verifique o valor enviado.");
            }
            
            // Adiciona valor do faturamento
            if (isset($tributoDataFiscal["faturamento"][$faturamento_fiscal])) {
                if ($tributoDataFiscal["faturamento"][$faturamento_fiscal] !== "Personalizar") {
                    $total_fiscal += $tributoDataFiscal["faturamento"][$faturamento_fiscal];
                } else {
                    $personalizar_fiscal = true;
                }
            } else {
                exibirErro("Faturamento fiscal não encontrado. Valor: '$faturamento_fiscal'. Verifique o valor enviado.");
            }
            
            // Aplica opções adicionais
            $subtotal_fiscal = $total_fiscal;
            if (mapearValores($_POST["fatorR_escolhido"], 'sim_nao') == "SIM") {
                $total_fiscal += 50; // Valor fixo para fator R
            }
            if (mapearValores($_POST["compraeVendaForaEscolhido"], 'sim_nao') == "SIM") {
                $total_fiscal += $subtotal_fiscal * 0.30; // 30% sobre o subtotal
            }
            if (mapearValores($_POST["atendimento_cliente_tribut"], 'sim_nao') == "SIM") {
                $total_fiscal += $subtotal_fiscal * 0.5;
            }
            
            // Calcula com inflação
            $total_fiscal_final = $total_fiscal + ($total_fiscal * $inflacao);
            $exibir_fiscal = true;
            
        } else {
            exibirErro("Regime de tributação não encontrado. Valor: '$tributo_fiscal'. Verifique o valor enviado.");
        }
    }
}

// ===== PROCESSAMENTO DEPARTAMENTO PESSOAL =====
if ($dp_preenchido) {
    $total = 0;

    // Calcula base pela modalidade da folha
    $modalidade = mapearValores($_POST["modalidade_folhaEscolhido"], 'modalidade');

    switch ($modalidade) {
        case 'Sem Movimento':
            $total = 20;
            break;
        case 'Eventos Fixos':
            $total = max(20, ($_POST['qtd_funcionarioEscolhido'] ?? 1) * 20);
            break;
        case 'Eventos Variáveis':
            $total = max(20, ($_POST['qtd_funcionarioEscolhido'] ?? 1) * 25);
            break;
        case 'Horista':
            $total = max(20, ($_POST['qtd_funcionarioEscolhido'] ?? 1) * 35);
            break;
        default:
            $total = 0;
            break;
    }

    // Aplica opções adicionais
    $qtd_funcionarios = mapearValores($_POST['qtd_funcionarioEscolhido'], 'qtd_funcionarios') ?? 1;

    if (mapearValores($_POST["atendimento_backofficeEscolhido"], 'sim_nao') == "SIM") {
        $total += $qtd_funcionarios * 7 + 30;
    }
    if (mapearValores($_POST["controle_feriasEscolhido"], 'sim_nao') == "SIM") {
        $total += $qtd_funcionarios * 3 + 10;
    }
    if (mapearValores($_POST["controle_afastamentosEscolhido"], 'sim_nao') == "SIM") {
        $total += $qtd_funcionarios * 3 + 10;
    }
    if (mapearValores($_POST["controle_beneficiosEscolhido"], 'sim_nao') == "SIM") {
        $total += $qtd_funcionarios * 10;
    }
    if (mapearValores($_POST["contrato_foradopadraoEscolhido"], 'sim_nao') == "SIM") {
        $total += 1000;
    }
    if (mapearValores($_POST["controle_bancodehorasEscolhido"], 'sim_nao') == "SIM") {
        $total += $qtd_funcionarios * 10;
    }
    if (mapearValores($_POST["acordo_de_trabalhoEscolhido"], 'sim_nao') == "SIM") {
        $total += 100;
    }
    if (mapearValores($_POST["descricao_de_cargosetrabalhosEscolhido"], 'sim_nao') == "SIM") {
        $total += 400;
    }

    // Calcula total do departamento pessoal
    $dp_total = $total * (18 / 100) + $total;
    $total_dp = $dp_total + ($dp_total * $inflacao);
    $exibir_dp = true;
}

// ===== EXIBIÇÃO DOS RESULTADOS =====
// Exibe apenas os departamentos que foram preenchidos
if (true) {
    if ($personalizar_contabil) {
        echo "<div class='card mb-4'><div class='card-body'><h5>Total da Contabilidade:</h5><h1>Personalizar</h1></div></div>";
    } else {
        echo "<div class='card mb-4'><div class='card-body'><h5>Total da Contabilidade:</h5><h1>R$: " . number_format($total_contabilidade, 2, ',', '.') . "</h1></div></div>";
    }
} else {
    echo "<div class='card mb-4'><div class='card-body'><h5>Total da Contabilidade:</h5><h1>R$: 0,00</h1></div></div>";
}

if (true) {
    if ($personalizar_fiscal) {
        echo "<div class='card mb-4'><div class='card-body'><h5>Total do Fiscal:</h5><h1>Personalizar</h1></div></div>";
    } else {
        echo "<div class='card mb-4'><div class='card-body'><h5>Total do Fiscal:</h5><h1>R$: " . number_format($total_fiscal_final, 2, ',', '.') . "</h1></div></div>";
    }
} else {
    echo "<div class='card mb-4'><div class='card-body'><h5>Total do Fiscal:</h5><h1>R$: 0,00</h1></div></div>";
}

if (true) {
    echo "<div class='card mb-4'><div class='card-body'><h5>Total do Departamento Pessoal:</h5><h1>R$: " . number_format($total_dp, 2, ',', '.') . "</h1></div></div>";
} else {
    echo "<div class='card mb-4'><div class='card-body'><h5>Total do Departamento Pessoal:</h5><h1>R$: 0,00</h1></div></div>";
}

// Calcula e exibe o total do backoffice
$total_backoffice = $total_contabilidade + $total_fiscal_final + $total_dp;

echo "<div class='card mb-4'><div class='card-body'><h5>Total do Backoffice:</h5><h1>R$: " . number_format($total_backoffice, 2, ',', '.') . "</h1></div></div>";
echo "<input type='hidden' id='total_bckoff' value='" . number_format($total_backoffice, 2, ',', '.') . "'></input>";
?>