// Função genérica para capturar o valor selecionado e definir no campo alvo
function updateSelectedValue(source, target) {
  var value = $(source).val();
  $(target).val(value);
}

// Aplicar a função genérica para os campos repetidos
const formFields = [
  { select: '#Tributo', input: '#tributoEscolhido' },
  { select: '#atividade', input: '#atividadeEscolhida' },
  { select: '#prazodeentrega_contabil', input: '#prazodeentrega_contabilescolhido' },
  { select: '#faturamento', input: '#faturamentoEscolhido' },
  { select: '#licitacao', input: '#licitacaoEscolhido' },
  { select: '#entidade_gov', input: '#entidade_govEscolhido' },
  { select: '#atendimento_cli', input: '#atendimento_cliEscolhido' },
  { select: '#reunioes_cliente', input: '#reunioes_clienteEscolhido' },
  { select: '#dashboardBI', input: '#dashboardBIEscolhido' },
  { select: '#prazoEntrega', input: '#prazoEntregaEscolhido' },
  { select: '#regimetribut_trib', input: '#tributoEscolhido_trib' },
  { select: '#atividade_trib', input: '#atividadeEscolhida_trib' },
  { select: '#faturamento_tribut', input: '#faturamentoEscolhido_tribut' },
  { select: '#planejamentotribut', input: '#planejamentotribut_escolhido' },
  { select: '#analise_ncm', input: '#analise_ncm_escolhido' },
  { select: '#atendimento_cliente_tribut', input: '#atendimento_cliente_tribut_esolhido' },
  { select: '#fatorR', input: '#fatorR_escolhido' },
  { select: '#tributSimplesCard', input: '#tributSimplesCardEscolhido' },
  { select: '#modalidade_folha', input: '#modalidade_folhaEscolhido' },
  { select: '#qtd_funcionario', input: '#qtd_funcionarioEscolhido' },
  { select: '#atendimento_backoffice', input: '#atendimento_backofficeEscolhido' },
  { select: '#controle_ferias', input: '#controle_feriasEscolhido' },
  { select: '#controle_afastamentos', input: '#controle_afastamentosEscolhido' },
  { select: '#controle_beneficios', input: '#controle_beneficiosEscolhido' },
  { select: '#contrato_foradopadrao', input: '#contrato_foradopadraoEscolhido' },
  { select: '#controle_bancodehoras', input: '#controle_bancodehorasEscolhido' },
  { select: '#acordo_de_trabalho', input: '#acordo_de_trabalhoEscolhido' },
  { select: '#descricao_de_cargosetrabalhos', input: '#descricao_de_cargosetrabalhosEscolhido' }
];

// Loop para associar os eventos 'change'
formFields.forEach(function(field) {
  $(field.select).on('change', function() {
    updateSelectedValue(this, field.input);
  });
});

// Campo especial para compra e venda
$('#compraeVendaFora').on('change', function() {
  var values = $(this).val();
  $('#compraeVendaForaEscolhido').val(values);
});

// Validação e envio de formulário com AJAX
$('#resumeForm').validate({
  submitHandler: function(form) {
    var $form = $(form),
    str = $form.serialize();

    $.ajax({
      type: "POST",
      url: $form.attr('action'),
      data: str,
      beforeSend: function() {
        $("#status").html("<i class='fa fa-spinner fa-pulse fa-3x fa-fw'></i> Enviando...");
      },
      success: function(responseText) {
        $(".response").html(responseText).hide().slideDown("slow");
      }
    });
  }
});

// Cálculo de valores de honorários e porcentagens
$('#valor_honorario').on('change', function() {
  var total_bckoff = parseFloat($('#total_bckoff').val()) || 0;
  var valor_honorario = parseFloat($('#valor_honorario').val()) || 0;

  if (valor_honorario === 0) {
    $('#percent_cf, #percent_franqueado, #Royalties').html("0.00");
    return;
  }

  var royalties = valor_honorario * 0.12;
  var percent_franqueado = (total_bckoff / valor_honorario) * 100;
  var percent_cf = 100 - percent_franqueado;

  $('#percent_cf').html(percent_cf.toFixed(2));
  $('#percent_franqueado').html(percent_franqueado.toFixed(2));
  $('#Royalties').html(royalties.toFixed(2));

  console.log({ total_bckoff, percent_franqueado, percent_cf, royalties });
});