<?php
//var_dump($_POST);
// Inicializa a variável personalizar e outras que podem ser utilizadas
$personalizar = false; // Inicialize como falso por padrão
if (!empty($_POST["tributoEscolhido_contabil"])) { // Agora usando _text para pegar o texto do select

        // Arrays para armazenar os valores de cada regime de tributação e atividade
        $tributos = [
        "Simples Nacional" => [
            "Serviço" => 30,
            "Comércio" => 40,
            "Indústrias" => 100,
            "ONGs" => 100,
            "Comércio e Serviço" => 100,
            "Construtora" => 100,
            "faturamento" => [
                "Contabilidade Pelo Caixa" => 10,  
                "0 a 10 MIL" => 20,
                "10 a 20 MIL" => 30,
                "20 a 30 MIL" => 40,
                "30 a 40 MIL" => 50,
                "40 a 50 MIL" => 60,
                "50 a 100 MIL" => 70,
                // Subdivisão de 100 a 500 MIL
                "100 a 200 MIL" => 80,
                "200 a 300 MIL" => 90,
                "300 a 400 MIL" => 100,
                "400 a 500 MIL" => 120,
                // Subdivisão de 500 a 1.000.000 MIL
                "500 a 600 MIL" => 140,
                "600 a 700 MIL" => 160,
                "700 a 800 MIL" => 180,
                "800 a 900 MIL" => 190,
                "900 a 1.000.000 MIL" => 200,
                "ACIMA DE 1.000.000 MIL" => "Personalizar"
            ]
        ],
         "Lucro Real" => [
            "Serviço" => 100,  // Valor base para Serviço no Lucro Real
            "Comércio" => 150,
            "Indústrias" => 180,
            "ONGs" => 180,
            "Comércio e Serviço" => 180,
            "Construtora" => 200,
            "faturamento" => [
                "Contabilidade Pelo Caixa" => 60,
                "0 a 10 MIL" => 30,
                "10 a 20 MIL" => 45,
                "20 a 30 MIL" => 60,
                "30 a 40 MIL" => 80,
                "40 a 50 MIL" => 100,  // Valor para Faturamento até 50k
                "50 a 100 MIL" => 130,
                // Subdivisão de 100 a 500 MIL
                "100 a 200 MIL" => 150,
                "200 a 300 MIL" => 170,
                "300 a 400 MIL" => 190,
                "400 a 500 MIL" => 200,
                // Subdivisão de 500 a 1.000.000 MIL
                "500 a 600 MIL" => 220,
                "600 a 700 MIL" => 240,
                "700 a 800 MIL" => 260,
                "800 a 900 MIL" => 280,
                "900 a 1.000.000 MIL" => 300,
                "ACIMA DE 1.000.000 MIL" => "Personalizar"
            ]
        ],
        "Lucro Presumido" => [
            "Serviço" => 50,
            "Comércio" => 60,
            "Indústrias" => 110,
            "ONGs" => 110,
            "Comércio e Serviço" => 110,
            "Construtora" => 110,
            "faturamento" => [
                "Contabilidade Pelo Caixa" => 60,
                "0 a 10 MIL" => 35,
                "10 a 20 MIL" => 50,
                "20 a 30 MIL" => 70,
                "30 a 40 MIL" => 90,
                "40 a 50 MIL" => 110,
                "50 a 100 MIL" => 180,
                // Subdivisão de 100 a 500 MIL
                "100 a 200 MIL" => 200,
                "200 a 300 MIL" => 220,
                "300 a 400 MIL" => 240,
                "400 a 500 MIL" => 250,
                // Subdivisão de 500 a 1.000.000 MIL
                "500 a 600 MIL" => 270,
                "600 a 700 MIL" => 290,
                "700 a 800 MIL" => 310,
                "800 a 900 MIL" => 330,
                "900 a 1.000.000 MIL" => 350,
                "ACIMA DE 1.000.000 MIL" => "Personalizar"
            ]
        ]
    ];

    // Inicializa o total
    $total = 0;
    $tributo = $_POST["tributoEscolhido_contabil"]; // Pega o texto do select de tributação
    $atividade = $_POST["atividadeEscolhida_contabil"]; // Pega o texto do select de atividade
    $faturamento = $_POST["faturamentoEscolhido_contabil"]; // Pega o texto do select de faturamento


    // Verifica se o tributo escolhido existe no array
    if (isset($tributos[$tributo])) {
        $tributoData = $tributos[$tributo];

        // Se "Contabilidade Pelo Caixa" for selecionado, o valor é fixo de R$ 60
        if ($faturamento === "Contabilidade Pelo Caixa") {
            $total = 40;
             if ($tributo === "Lucro Real") {
                  echo "<div class='card mb-4'><div class='card-body'><h2 style='color: red;'>Contabilidade para lucro real não pode ser pelo caixa</h2></div></div>";
                  
             }
        } else {
            // Adiciona o valor de acordo com a atividade
            if (isset($tributoData[$atividade])) {
                $total += $tributoData[$atividade];
            } else {
                // Exibe uma mensagem de erro caso a atividade não esteja correta
                echo "Erro: Atividade não encontrada. Verifique o valor enviado.";
            }

            // Adiciona o valor de acordo com o faturamento
            if (isset($tributoData["faturamento"][$faturamento])) {
                if ($tributoData["faturamento"][$faturamento] !== "Personalizar") {
                    $total += $tributoData["faturamento"][$faturamento];
                } else {
                    // Lógica de personalização caso necessário
                    $personalizar = true;
                }
            } else {
                // Exibe uma mensagem de erro caso o faturamento não esteja correto
                echo "Erro: Faturamento não encontrado. Verifique o valor enviado.";
            }
        }
    } else {
        // Exibe uma mensagem de erro caso o tributo não seja encontrado
        echo "Erro: Regime de tributação não encontrado. Verifique o valor enviado.";
    }

    // Verifica as opções adicionais
    $subtotal = $total;
    if ($_POST["licitacaoEscolhido_contabil"] == "SIM") {
        $total += $subtotal * 0.2;
    }
    if ($_POST["entidade_govEscolhido_contabil"] == "SIM") {
        $total += $subtotal * 0.2;
    }
    if ($_POST["atendimento_cliEscolhido_contabil"] == "SIM") {
        $total += $subtotal * 0.5;
    }
    if ($_POST["dashboardBIEscolhido_contabil"] == "SIM") {
        $total += $subtotal * 0.2;
    }
    if ($_POST["prazoEntregaEscolhido_contabil"] == "SIM") {
        $total += $subtotal * 0.2;
    }

    // Cálculo da contabilidade com inflação
    $inflacao = 0.1; // Valor da inflação a ser ajustado conforme necessidade
    $calculo_da_contabilidade = $total + ($total * 0.3642);
    $total_contab = $calculo_da_contabilidade + ($calculo_da_contabilidade * $inflacao);
    //$total_contab = $total;
    // Ajuste de acordo com o período de entrega
    $prazodeentrega = $_POST['prazodeentrega_contabilescolhido'];
    switch ($prazodeentrega) {
        case "Mensal":
            $total_contabilidade = $total_contab;
            break;

        case "Semestral":
            $total_contabilidade = $total_contab * 6;
            $desconto = (40 / 100) * $total_contabilidade;
            $total_contabilidade_comdesconto = $total_contabilidade - $desconto;
            echo "<div class='card mb-4'><div class='card-body'><h5 style='color: red;'>Total da Contabilidade Semestral com desconto:</h5><h1>R$: ".number_format($total_contabilidade_comdesconto, 2, ',', '.')."</h1></div></div>";
            $total_contabilidade = $total_contab;
            break;

        case "Trimestral":
            $total_contabilidade = $total_contab * 3;
            $desconto = (30 / 100) * $total_contabilidade;
            $total_contabilidade_comdesconto = $total_contabilidade - $desconto;
            echo "<div class='card mb-4'><div class='card-body'><h5 style='color: red;'>Total da Contabilidade Trimestral com desconto:</h5><h1>R$: ".number_format($total_contabilidade_comdesconto, 2, ',', '.')."</h1></div></div>";
            $total_contabilidade = $total_contab;
            break;

        case "Anual":
            $total_contabilidade = $total_contab * 12;
            $desconto = (50 / 100) * $total_contabilidade;
            $total_contabilidade_comdesconto = $total_contabilidade - $desconto;
            echo "<div class='card mb-4'><div class='card-body'><h5 style='color: red;'>Total da Contabilidade Anual com desconto:</h5><h1>R$: ".number_format($total_contabilidade_comdesconto, 2, ',', '.')."</h1></div></div>";
            $total_contabilidade = $total_contab;
            break;

        default:
            $total_contabilidade = $total_contab;
            break;
    }

    // Verifica se o cliente será atendido pelo Backoffice
    if ($_POST["atendimento_cliEscolhido_contabil"] == "SIM") {
        $acrescimo_backoffice = $total_contabilidade * 0.10;
        $total_contabilidade += $acrescimo_backoffice;
    }
}
//FIM DO CONTÁBIL

// TRIBUTÁRIO
if (!empty($_POST["tributoEscolhido_tribut"])) { // Captura o tributo fiscal escolhido

    // Arrays para armazenar os valores de cada regime de tributação e atividade para o Fiscal/Tributário
    $tributos_fiscal = [
        "Simples Nacional" => [
            "Serviço" => 50,
            "Comércio" => 80,
            "Indústrias" => 100,
            "ONGs" => 100,
            "Comércio e Serviço" => 100,
            "Construtora" => 100,
            "faturamento" => [
                "0 a 10 MIL" => 10,
                "10 a 20 MIL" => 13,
                "20 a 30 MIL" => 15,
                "30 a 40 MIL" => 18,
                "40 a 50 MIL" => 22,
                "50 a 100 MIL" => 28,
                "100 a 200 MIL" => 50,
                "200 a 300 MIL" => 55,
                "300 a 400 MIL" => 70,
                "400 a 500 MIL" => 75,
                "500 a 600 MIL" => 100,
                "600 a 700 MIL" => 130,
                "700 a 800 MIL" => 160,
                "800 a 900 MIL" => 190,
                "900 a 1.000.000 MIL" => 250,
                "ACIMA DE 1.000.000 MIL" => "Personalizar"
            ]
        ],
        "Lucro Real" => [
            "Serviço" => 150,
            "Comércio" => 200,
            "Indústrias" => 200,
            "ONGs" => 200,
            "Comércio e Serviço" => 200,
            "Construtora" => 200,
            "faturamento" => [
                "0 a 10 MIL" => 30,
                "10 a 20 MIL" => 45,
                "20 a 30 MIL" => 60,
                "30 a 40 MIL" => 80,
                "40 a 50 MIL" => 100,
                "50 a 100 MIL" => 130,
                "100 a 200 MIL" => 150,
                "200 a 300 MIL" => 170,
                "300 a 400 MIL" => 190,
                "400 a 500 MIL" => 200,
                "500 a 600 MIL" => 220,
                "600 a 700 MIL" => 240,
                "700 a 800 MIL" => 260,
                "800 a 900 MIL" => 280,
                "900 a 1.000.000 MIL" => 300,
                "ACIMA DE 1.000.000 MIL" => "Personalizar"
            ]
        ],
        "Lucro Presumido" => [
            "Serviço" => 100,
            "Comércio" => 150,
            "Indústrias" => 150,
            "ONGs" => 150,
            "Comércio e Serviço" => 150,
            "Construtora" => 150,
            "faturamento" => [
                "0 a 10 MIL" => 35,
                "10 a 20 MIL" => 50,
                "20 a 30 MIL" => 70,
                "30 a 40 MIL" => 90,
                "40 a 50 MIL" => 110,
                "50 a 100 MIL" => 180,
                "100 a 200 MIL" => 200,
                "200 a 300 MIL" => 220,
                "300 a 400 MIL" => 240,
                "400 a 500 MIL" => 250,
                "500 a 600 MIL" => 270,
                "600 a 700 MIL" => 290,
                "700 a 800 MIL" => 310,
                "800 a 900 MIL" => 330,
                "900 a 1.000.000 MIL" => 350,
                "ACIMA DE 1.000.000 MIL" => "Personalizar"
            ]
        ]
    ];

    // Inicializa o total
    $total_fiscal = 0;
    $tributo_fiscal = $_POST["tributoEscolhido_tribut"]; // Pega o tributo fiscal
    $atividade_fiscal = $_POST["atividadeEscolhida_trib"]; // Pega a atividade fiscal
    $faturamento_fiscal = $_POST["faturamentoEscolhido_trib"]; // Pega o faturamento fiscal

    // Verifica se o tributo escolhido existe no array
    if (isset($tributos_fiscal[$tributo_fiscal])) {
        $tributoDataFiscal = $tributos_fiscal[$tributo_fiscal];

        // Adiciona o valor de acordo com a atividade
        if (isset($tributoDataFiscal[$atividade_fiscal])) {
            $total_fiscal += $tributoDataFiscal[$atividade_fiscal];
        } else {
            echo "Erro: Atividade fiscal não encontrada. Verifique o valor enviado.";
        }

        // Adiciona o valor de acordo com o faturamento
        if (isset($tributoDataFiscal["faturamento"][$faturamento_fiscal])) {
            if ($tributoDataFiscal["faturamento"][$faturamento_fiscal] !== "Personalizar") {
                $total_fiscal += $tributoDataFiscal["faturamento"][$faturamento_fiscal];
            } else {
                $personalizar = true;
            }
        } else {
            echo "Erro: Faturamento fiscal não encontrado. Verifique o valor enviado.";
        }
    } else {
        echo "Erro: Regime de tributação fiscal não encontrado. Verifique o valor enviado.";
    }

    // Verifica se há opções adicionais, como fator R e compra/venda fora do estado
    $subtotal_fiscal = $total_fiscal;
    if ($_POST["fatorR_escolhido"] == "SIM" OR $_POST["fatorR_escolhido"] == "sim") {
        $total_fiscal += 50; // Valor fixo para fator R
    }
    if ($_POST["compraeVendaForaEscolhido"] == "SIM" OR $_POST["compraeVendaForaEscolhido"] == "sim") {
        $total_fiscal += $subtotal_fiscal * 0.30; // 30% sobre o subtotal
    }
    if ($_POST["atendimento_cliente_tribut"] == "SIM" OR $_POST["atendimento_cliente_tribut"] == "sim") {
        $total_fiscal += $subtotal_fiscal * 0.5;
    }

    // Cálculo final do Fiscal com inflação
    $inflacao = 0.1; // Exemplo de inflação
    $total_fiscal_final = $total_fiscal + ($total_fiscal * $inflacao);

}

//DEPARTAMENTO PESSOA

$total_dp = 0;
$total = 0;
//Atividade
/*Horista 35 */
switch ($_POST["modalidade_folhaEscolhido"]) {
  case 'Sem Movimento':
  $total = 20;
  break;

  case 'Eventos Fixos':

  if (1 <= $_POST['qtd_funcionarioEscolhido']) {
      $total += $_POST['qtd_funcionarioEscolhido'] * 20;
  } else {
      $total = 20;
  }

  break;

  case 'Eventos Variáveis':
  if (1 <= $_POST['qtd_funcionarioEscolhido']) {
      $total += $_POST['qtd_funcionarioEscolhido'] * 25;
  } else {
      $total = 20;
  }
  break;

  case 'Horista':
  if (1 <= $_POST['qtd_funcionarioEscolhido']) {
      $total += $_POST['qtd_funcionarioEscolhido'] * 35;
  } else {
      $total = 20;
  }
  break;

  default:
  $total = 0;
  // code...
  break;
}

if ($_POST["atendimento_backofficeEscolhido"] == "SIM") {
    $p = 30;
    $x = $_POST['qtd_funcionarioEscolhido']*7 + $p;
    $total = $total+$x;
}
if ($_POST["controle_feriasEscolhido"] == "SIM") {
    $p = 10;
    $x = $_POST['qtd_funcionarioEscolhido']*3 + $p;
    $total = $total+$x;
}
if ($_POST["controle_afastamentosEscolhido"] == "SIM") {
    $p = 10;
    $x = $_POST['qtd_funcionarioEscolhido']*3 + $p;
    $total = $total+$x;
}
if ($_POST["controle_beneficiosEscolhido"] == "SIM") {
    $p = 10;
    $x = $_POST['qtd_funcionarioEscolhido']*$p;
    $total = $total+$x;
}
if ($_POST["contrato_foradopadraoEscolhido"] == "SIM") {
    $p = 1000;
    $total = $total+$p;
}
if ($_POST["controle_bancodehorasEscolhido"] == "SIM") {
    $p = 10;
    $x = $_POST['qtd_funcionarioEscolhido']*$p;
    $total = $total+$x;
}
if ($_POST["acordo_de_trabalhoEscolhido"] == "SIM") {
    $p = 100;
    $total = $total+$p;
}
if ($_POST["descricao_de_cargosetrabalhosEscolhido"] == "SIM") {
    $p = 400;
    $total = $total+$p;
}
//DEPARTAMENTO PESSOA

$total_dp = 0;
$total = 0;
/* Horista 35 */
switch ($_POST["modalidade_folhaEscolhido"]) {
    case 'Sem Movimento':
        $total = 20;
        break;
    case 'Eventos Fixos':
        $total = max(20, $_POST['qtd_funcionarioEscolhido'] * 20);
        break;
    case 'Eventos Variáveis':
        $total = max(20, $_POST['qtd_funcionarioEscolhido'] * 25);
        break;
    case 'Horista':
        $total = max(20, $_POST['qtd_funcionarioEscolhido'] * 35);
        break;
    default:
        $total = 0;
        break;
}

if ($_POST["atendimento_backofficeEscolhido"] == "SIM") {
    $total += $_POST['qtd_funcionarioEscolhido'] * 7 + 30;
}
if ($_POST["controle_feriasEscolhido"] == "SIM") {
    $total += $_POST['qtd_funcionarioEscolhido'] * 3 + 10;
}
if ($_POST["controle_afastamentosEscolhido"] == "SIM") {
    $total += $_POST['qtd_funcionarioEscolhido'] * 3 + 10;
}
if ($_POST["controle_beneficiosEscolhido"] == "SIM") {
    $total += $_POST['qtd_funcionarioEscolhido'] * 10;
}
if ($_POST["contrato_foradopadraoEscolhido"] == "SIM") {
    $total += 1000;
}
if ($_POST["controle_bancodehorasEscolhido"] == "SIM") {
    $total += $_POST['qtd_funcionarioEscolhido'] * 10;
}
if ($_POST["acordo_de_trabalhoEscolhido"] == "SIM") {
    $total += 100;
}
if ($_POST["descricao_de_cargosetrabalhosEscolhido"] == "SIM") {
    $total += 400;
}

$dp_total = $total * (18 / 100) + $total;
$total_dp = $dp_total + ($dp_total * $inflacao);
$total_backo = $total_contabilidade + $total_fiscal_final + $total_dp;

// Exibição de valores
if ($personalizar == true) {
    echo "<div class='card mb-4'><div class='card-body '><h5>Total da Contabilidade:</h5><h1>Personalizar</h1></div></div>";
    echo "<div class='card mb-4'><div class='card-body '><h5>Total do Fiscal:</h5><h1>Personalizar</h1></div></div>";
    echo "<div class='card mb-4'><div class='card-body '><h5>Total do Departamento Pessoal:</h5><h1>R$: ".number_format($total_dp, 2, ',', '.')."</h1></div></div>";
} else {
    echo "<div class='card mb-4'><div class='card-body '><h5>Total da Contabilidade:</h5><h1>R$: ".number_format($total_contabilidade, 2, ',', '.')."</h1></div></div>";
    echo "<div class='card mb-4'><div class='card-body '><h5>Total do Fiscal:</h5><h1>R$: ".number_format($total_fiscal_final, 2, ',', '.')."</h1></div></div>";
    echo "<div class='card mb-4'><div class='card-body '><h5>Total do Departamento Pessoal:</h5><h1>R$: ".number_format($total_dp, 2, ',', '.')."</h1></div></div>";
    echo "<div class='card mb-4'><div class='card-body '><h5>Total do Backoffice:</h5><h1>R$: ".number_format($total_backo, 2, ',', '.')."</h1></div></div>";
    echo "<input type='hidden' id='total_bckoff' value='".number_format($total_backo, 2, ',', '.')."'</input>";
}

?>